set -e
set -a
source variables.env
set +a

echo "=========================================="
echo "  Starting OneConnect Deployment"
echo "=========================================="
echo ""
echo "  Current Deployment Mode: $DEPLOYMENT_MODE"
echo ""

# =============================
# Dynamic Kafka configuration
# =============================
if [ "$DEPLOYMENT_MODE" = "ONCLOUD" ]; then
  export KAFKAPROPERTIES_DEPLOYMENTTYPE="ONCLOUD"
  export KAFKAPROPERTIES_SECURITYPROTOCOL="SASL_SSL"
  echo "  → ONCLOUD mode detected"
  echo "    Security protocol set to SASL_SSL"
else
  export KAFKAPROPERTIES_DEPLOYMENTTYPE="ONPREMISE"
  export KAFKAPROPERTIES_SECURITYPROTOCOL="NO_SECURITY"
  echo "  → ONPREMISE mode detected"
  echo "    Security protocol set to NO_SECURITY"
fi

echo ""
echo "=========================================="
echo "  Authenticating to Docker Hub..."
echo "=========================================="
echo "$DOCKERHUB_TOKEN" | docker login -u "$DOCKERHUB_USER" --password-stdin

echo ""
echo "=========================================="
echo "  Starting containers with scaling..."
echo "=========================================="
docker compose --env-file variables.env up \
  --scale producer=$PRODUCER_SCALE \
  --scale consumer=$CONSUMER_SCALE \
  -d

echo ""
echo "=========================================="
echo "  Deployment finished successfully!"
echo "=========================================="
echo "   Access frontend:"
echo "   http://$HOST_MACHINE_IP:5050"
echo "=========================================="
